<?php

use PrestaShop\PrestaShop\Core\Domain\Product\ValueObject\ProductType;

/**
 * Deagor | WMS for Humans
 *
 *
 *  @author    Deagor SRLS <contact@deagor.io>
 *  @copyright 2020 Deagor SRLS
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  @category  Shipping
 *  @package   Deagor
 *  @link      https://deagor.io
 */
class DeagorServiceapiModuleFrontController extends ModuleFrontController {

    const LIMIT_FOR_SET    = 50;

    public function __construct() {
        parent::__construct();
    }

    public function httpResponseCode($code = null)
    {
        $statuses = array(
            '100' => 'Continue',
            '101' => 'Switching Protocols',
            '200' => 'OK',
            '201' => 'Created',
            '202' => 'Accepted',
            '203' => 'Non-Authoritative Information',
            '204' => 'No Content',
            '205' => 'Reset Content',
            '206' => 'Partial Content',
            '300' => 'Multiple Choices',
            '301' => 'Moved Permanently',
            '302' => 'Moved Temporarily',
            '303' => 'See Other',
            '304' => 'Not Modified',
            '305' => 'Use Proxy',
            '400' => 'Bad Request',
            '401' => 'Unauthorized',
            '402' => 'Payment Required',
            '403' => 'Forbidden',
            '404' => 'Not Found',
            '405' => 'Method Not Allowed',
            '406' => 'Not Acceptable',
            '407' => 'Proxy Authentication Required',
            '408' => 'Request Time-out',
            '409' => 'Conflict',
            '410' => 'Gone',
            '411' => 'Length Required',
            '412' => 'Precondition Failed',
            '413' => 'Request Entity Too Large',
            '414' => 'Request-URI Too Large',
            '415' => 'Unsupported Media Type',
            '500' => 'Internal Server Error',
            '501' => 'Not Implemented',
            '502' => 'Bad Gateway',
            '503' => 'Service Unavailable',
            '504' => 'Gateway Time-out',
            '505' => 'HTTP Version not supported',
        );

        $code = $code === null ? '200' : $code;
        $text = isset($statuses[$code]) ? $statuses[$code] : $statuses['200'];

        if (function_exists('http_response_code')) {
            return http_response_code((int)$code);
        } else {
            $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
            header($protocol . ' ' . $code . ' ' . $text);
            return $code;
        }
    }

    public function ImageExist($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }

    private function canAccess($_params){
        if ((!$_params['token']) || ($_params['token'] != Configuration::get('DEAGOR_TOKEN'))){
            return;
        } else {
            return true;
        }
    }

    public function initContent()
    {
        $this->httpResponseCode(200);

        $module 	= new Deagor;
        $_params 	= json_decode(Tools::getValue('params'), true);

        $_enabled = Configuration::get('DEAGOR_ENABLE', true);
        if (!$_enabled){
            $_return['status']	= 2;
            $_return['error'] 	= array(
                'code' 		=> 'ER01',
                'message'	=> 'Module Disabled'
            );
            $json = Tools::jsonEncode($_return);
            echo $json;
            return;
        }

        if (!$this->canAccess($_params)){
            $_return['status']	= 2;
            $_return['error'] 	= array(
                'code' 		=> 'ER03',
                'message'	=> 'Token error'
            );
            $json = Tools::jsonEncode($_return);
            echo $json;
            return;
        } else {
            if (Tools::getValue('action')){
                $_return['status']	= 1;
            } else {
                $_return['status']	= 2;
                $_return['error'] 	= array(
                    'code' 		=> 'ER02',
                    'message'	=> 'No Action'
                );
                $json = Tools::jsonEncode($_return);
                echo $json;
                return;
            }
        }

        $id_lang	= (int)Configuration::get('PS_LANG_DEFAULT');
        $dayToSync 	= Configuration::get('DEAGOR_DAYTOSYNC');
        $_status   	= Configuration::get('DEAGOR_STATUSSEND');
        $_eanAttr	= Configuration::get('DEAGOR_EAN');
        $_modelAttr = Configuration::get('DEAGOR_MODEL');
        $_cod_forn1 = Configuration::get('DEAGOR_FORN1');
        $_cod_forn2 = Configuration::get('DEAGOR_FORN2');
        $_cod_forn3 = Configuration::get('DEAGOR_FORN3');
        $_cod_forn4 = Configuration::get('DEAGOR_FORN4');
        $_page 		= (intval($_params['set'] ?? 0)+1);
        $start		= ($_page*self::LIMIT_FOR_SET)-self::LIMIT_FOR_SET;
        $limit		= self::LIMIT_FOR_SET;

        switch (Tools::getValue('action')) {

            case 'oauth':
                $_return['data']	= 1;
                break;

            case 'updateAttributes':

                $_return['data']	= array('success' => false, 'message' => '');

                $_sku				= @$_params['sku'];
                $_attributes 		= @$_params['attributes'];
                $_prdId 			= @$_params['channel_product_id'];
                //mail('info@dfsolution.it','ppp',Tools::getValue('params'));
                if (($_sku) && ($_attributes)){

                    $order_by	= 'id_product';
                    $order_way	= 'ASC';
                    $id_category= false;
                    $only_active= true;
                    $context 	= null;
                    $_hasId 	= false;
                    $_query['product'] = array(
                        'field' 	=> 'p.reference',
                        'operator' 	=> '=',
                        'filter'	=> $_sku,
                    );

                    $_collection 	= $this->getProducts($id_lang, 0, 1, $order_by, $order_way, $id_category, $only_active , $context, $_query);
                    if (!$_collection){
                        $_query['product'] = array(
                            'field' 	=> 'p.id_product',
                            'operator' 	=> '=',
                            'filter'	=> $_prdId,
                        );
                        $_collection 	= $this->getProducts($id_lang, 0, 1, $order_by, $order_way, $id_category, $only_active , $context, $_query);
                        $_hasId = true;
                    }

                    if ($_collection){

                        foreach ($_collection as $_product){
                            if (($_product['reference']!=$_sku) && (!$_hasId)){
                                continue;
                            }
                            $_hasUpdate = false;
                            $product = new Product($_product['id_product']);
                            foreach ($_attributes as $attribute => $_value){
                                if ($_value != $product->$attribute){
                                    $product->$attribute = $_value;
                                    $_hasUpdate = true;
                                }
                            }
                            if ($_hasUpdate){
                                $product->update();
                            }
                            $_return['data']['success'] = true;
                            $_return['data']['message'] = 'Product was update successful';
                        }

                    } else {
                        $_return['data']['message'] = 'No Product found';
                    }
                } else {
                    $_return['data']['message'] = "'sku' and 'attributes' params are required.";
                }

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;

            case 'updateAddress':

                $_return['data']	= array('success' => false, 'message' => '');
                $_orderId			= @$_params['ecommerce_id'];
                $_address 			= @$_params['address'];

                if (($_orderId) && ($_address)){

                    $_query['order'] = array(
                        'field' 	=> 'o.reference',
                        'operator' 	=> '=',
                        'filter'	=> $_orderId,
                    );

                    $_collection = $this->getOrdersWithInformations($limit, null, 0, $_query, false);

                    if ($_collection){

                        foreach ($_collection as $_order){

                            $delivery_details 	= new Address((int)($_order['id_address_delivery']));
                            $objOrder 			= new Order($_order['id_order']);
                            $_newAddress 		= $_params['address'];

                            $delivery_details->firstname 	= $_newAddress['firstname'];
                            $delivery_details->lastname 	= $_newAddress['lastname'];
                            $delivery_details->company		= $_newAddress['company'];
                            $delivery_details->address1		= $_newAddress['street_1'].' '.$_newAddress['number'];
                            $delivery_details->address2		= '';
                            $delivery_details->city			= $_newAddress['city'];
                            $delivery_details->postcode		= $_newAddress['postcode'];
                            $delivery_details->phone_mobile	= $_newAddress['mobile'];
                            $delivery_details->phone		= $_newAddress['telephone'];

                            $_country = Country::getByIso($_newAddress['country_iso2']);
                            if (!$_country){
                                $_country = Country::getByIso('IT');
                            }

                            $delivery_details->id_country	= $_country;

                            $_state = Db::getInstance()->getValue('
                            SELECT `id_state`
                            FROM `'._DB_PREFIX_.'state`
                            WHERE `iso_code` = \''.pSQL($_newAddress['region_code']).'\'
                            '.($_country ? 'AND `id_country` = '.(int)$_country : ''));

                            //$_state = State::getIdByIso($_newAddress['region_code'], $_country);
                            if (!$_state){
                                $_state = State::getIdByIso($_newAddress['region_code']);
                            }
                            $delivery_details->id_state		= $_state;
                            $objOrder->note 				= $_newAddress['note'];

                            $delivery_details->update();
                            //$objOrder->update();

                        }

                        $_return['data']['success'] = true;
                        $_return['data']['message'] = 'Order address was update successful';

                    } else {
                        $_return['data']['message'] = 'No Product found';
                    }

                } else {
                    $_return['data']['message'] = "Order ID and 'address' params are required.";
                }

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;

            case 'trackingOrder':

                $_return['data']	= array('success' => false, 'message' => '');
                $_orderId			= @$_params['shipping_increment'];
                $_tracking 			= @$_params['tracking'];
                $_carrier 			= @$_params['carrier'];
                if (($_orderId) && ($_tracking) && ($_carrier)){
                    $orders = Order::getByReference($_orderId);
                    $order = $orders->getFirst();
                    $orderCarrierId = $order->getIdOrderCarrier();
                    $orderCarrier = new OrderCarrier($orderCarrierId);
                    $orderCarrier->tracking_number = $_tracking;
                    $orderCarrier->save();
                    $_return['data']['success'] = true;
                    $_return['data']['message'] = 'Tracking was created successful';
                } else {
                    $_return['data']['message'] = 'No OrderID o Items parsed';
                }

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;

            case 'shipOrder':

                $_return['data']	= array('success' => false, 'message' => '');
                $_orderId 			= @$_params['ecommerce_id'];
                $_orderItems 		= @$_params['items'];
                $tracking       = @$_params['tracking'];

                if (($_orderId) && ($_orderItems)){

                    $_query['order'] = array(
                        'field' 	=> 'o.reference',
                        'operator' 	=> '=',
                        'filter'	=> $_orderId,
                    );

                    $_collection = $this->getOrdersWithInformations($limit, null, 0, $_query, false);

                    if ($_collection){

                        foreach ($_collection as $_order){

                            $objOrder 			= new Order($_order['id_order']);
                            $_shippedStatus = Configuration::get('PS_OS_SHIPPING');

                            $history 	= new OrderHistory();
                            $history->id_order = (int)$objOrder->id;
                            $history->changeIdOrderState($_shippedStatus, (int)($objOrder->id));
                            $history->add();

                            if ($tracking){
                              $id_order_carrier = Db::getInstance()->getValue('
                              SELECT `id_order_carrier`
                              FROM `' . _DB_PREFIX_ . 'order_carrier`
                              WHERE `id_order` = ' . (int) $objOrder->id);

                              if ($id_order_carrier) {
                                  $order_carrier = new OrderCarrier($id_order_carrier);
                                  $order_carrier->tracking_number = $tracking;
                                  $order_carrier->update();
                              } else {
                                  $objOrder->shipping_number = $tracking;
                              }
                            }

                        }

                        $_return['data']['success'] = true;
                        $_return['data']['ec_shipping_increment'] = $_orderId;
                        $_return['data']['message'] = 'Shipping was created successful';

                    } else {
                        $_return['data']['message'] = 'No OrderID found';
                    }


                } else {
                    $_return['data']['message'] = 'No OrderID o Items parsed';
                }

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;
            case 'deliverOrder':
                $_return['data'] = array('success' => false, 'message' => '');
                $_orderId = @$_params['ecommerce_id'];
                $_query['order'] = array(
                    'field' 	=> 'o.reference',
                    'operator' 	=> '=',
                    'filter'	=> $_orderId,
                );
                $_collection = $this->getOrdersWithInformations($limit, null, 0, $_query, false);
                if ($_collection) {
                    foreach ($_collection as $_order) {
                        $deliveredStatus = Configuration::get('DEAGOR_STATUSDELIVER');
                        $objOrder = new Order($_order['id_order']);
                        $history = new OrderHistory();
                        $history->id_order = (int)$objOrder->id;
                        $history->changeIdOrderState($deliveredStatus, (int)($objOrder->id));
                        $history->add();
                        $_return['data']['success'] = true;
                        $_return['data']['message'] = 'Order was delivered successful';
                    }
                }
                break;
            case 'cancelOrder':

                $_return['data']	= array('success' => false, 'message' => '');
                $_orderId 			= @$_params['order_id'];

                if ($_orderId){

                    $_query['order'] = array(
                        'field' 	=> 'o.id_order',
                        'operator' 	=> '=',
                        'filter'	=> $_orderId,
                    );

                    $_collection = $this->getOrdersWithInformations($limit, null, 0, $_query, false);

                    if ($_collection){

                        $_cancelStatus = Configuration::get('PS_OS_CANCELED');

                        $objOrder 	= new Order($_orderId);
                        $history 	= new OrderHistory();
                        $history->id_order = (int)$objOrder->id;
                        $history->changeIdOrderState($_cancelStatus, (int)($objOrder->id));
                        $history->add();

                        $_return['data']['success'] = true;
                        $_return['data']['message'] = 'Order Successfully canceled';

                    } else {
                        $_return['data']['message'] = 'No OrderID found';
                    }
                } else {
                    $_return['data']['message'] = 'No OrderID parsed';
                }

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;

            case 'getOrderItems':

                $_orderId = @$_params['ecommerce_id'];
                if (!$_orderId) {
                    $_return['status']	= 2;
                    $_return['error'] 	= array(
                        'code' 		=> 'ER03',
                        'message'	=> 'No ID Parsed'
                    );
                    $json = Tools::jsonEncode($_return);
                    $this->ajaxDie($json);
                    return;
                }

                $_query['order'] = array(
                    'field' 	=> 'o.reference',
                    'operator' 	=> '=',
                    'filter'	=> $_orderId,
                );

                $_collection = $this->getOrdersWithInformations($limit, null, 0, $_query, false);

                $_isLast 	 = true;

                if (!count($_collection)){
                    $_return['data']['data'] = array();
                }

                foreach ($_collection as $_idx => $_order){

                    $order 		= new Order($_order['id_order']);
                    $products	=$order->getProducts();

                    foreach ($products as $_key => $item) {
                        //print_r($item);
                        if (!$item['product_reference']){
                            continue;
                        }

                        $_product = new Product($item['product_id']);

                        $item_qty_refunded = abs($item['product_quantity_refunded']);
                        if ($item_qty_refunded){
                            $_qty = $item['product_quantity']-$item_qty_refunded;
                        } else {
                            $_qty = $item['product_quantity'];
                        }

                        if (!$_qty){
                            continue;
                        }

                        $_basePrice = ($item['total_price_tax_incl'])/$_qty;
                        if ($children = $_product->getWsProductBundle()) {
                            $_basePrice = $_basePrice / count($children);
                            foreach ($children as $child) {
                                $childProduct = new Product($child['id']);
                                if (isset($_return['data']['data'][$child['id']])) {
                                    $_return['data']['data'][$child['id']]['qty'] += ($_qty * $child['quantity']);
                                } else {
                                    $_return['data']['data'][$child['id']]['price']	= number_format($_basePrice,2,'.','');
                                    $_return['data']['data'][$child['id']]['ec_row_id']= $item['id_order_detail'];
                                    $_return['data']['data'][$child['id']]['sku'] = $childProduct->reference;


                                    $_customized = '';
                                    if (isset($item['customizedDatas']) && $item['customizedDatas']){
                                        foreach ($item['customizedDatas'] as $customizedInfo){
                                            foreach ($customizedInfo as $customized){
                                                if (isset($customized['datas']) && $customized['datas']){
                                                    foreach ($customized['datas'] as $dataCustomized){
                                                        foreach ($dataCustomized as $data){
                                                            $_customized = ' - PERSONALIZZAZIONE : '.$data['name'].' : '.$data['value'];
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    $_return['data']['data'][$child['id']]['original_sku'] = $item['product_reference'];
                                    $_return['data']['data'][$child['id']]['original_name'] = $item['product_name'].$_customized;
                                    if (($item['customizable']==2) || ($item['customizable']==1)){
                                        $_return['data']['data'][$child['id']]['tags'][] = 'Personalizzabile&&&&#f800ff';
                                    }
                                    $_return['data']['data'][$child['id']]['qty'] = $_qty * $child['quantity'];
                                    $_return['data']['data'][$child['id']]['bundle_qty'] = $_qty;
                                    $_return['data']['data'][$child['id']]['name'] = is_array($childProduct->name) ? array_values($childProduct->name)[0] : $childProduct->name;
                                    $_return['data']['data'][$child['id']]['channel_product_id'] = $childProduct->id;
                                    $image = Image::getCover($child['id']);
                                    $link = new Link;
                                    $imagePath = $link->getImageLink($_product->link_rewrite[Context::getContext()->language->id], $image['id_image'], 'home_default');
                                    if ($imagePath){
                                        if (strpos($imagePath, 'http') === false) {
                                            $imagePath = 'https://'.$imagePath;
                                        }
                                    }
                                    $_return['data']['data'][$child['id']]['image'] = $imagePath;
                                    if (strpos($childProduct->reference, 'FTC') === false) {
                                        if (($_eanAttr) && isset($childProduct->{$_eanAttr})){
                                            $_return['data']['data'][$child['id']]['ean'] = $childProduct->{$_eanAttr};
                                        } else {
                                            $_return['data']['data'][$child['id']]['ean'] = $childProduct->ean13;
                                        }
                                    }

                                    $_return['data']['data'][$child['id']]['actualqty'] = StockAvailableCore::getQuantityAvailableByProduct($child['id']);

                                    $_allAttribute = array();
                                    $_features = Product::getFrontFeaturesStatic($id_lang, $child['id']);
                                    if ($_features){
                                        foreach ($_features as $_feature){
                                            $_allAttribute['feat_'.$_feature['id_feature']] = $_feature['value'];
                                        }
                                    }

                                    if ($childProduct->manufacturer_name){
                                        $_allAttribute['manufacturer'] = $childProduct->manufacturer_name;
                                    }

                                    if ($_modelAttr) {
                                        if (array_key_exists($_modelAttr,$_allAttribute)){
                                            $_return['data']['data'][$child['id']]['model'] = $_allAttribute[$_modelAttr];
                                        } else {
                                            $_return['data']['data'][$child['id']]['model'] = '';
                                        }
                                    }
                                    if ($_cod_forn1) {
                                        if (array_key_exists($_cod_forn1,$_allAttribute)){
                                            $_return['data']['data'][$child['id']]['cod_forn1'] = $_allAttribute[$_cod_forn1];
                                        } else {
                                            $_return['data']['data'][$child['id']]['cod_forn1'] = '';
                                        }
                                    }
                                    if ($_cod_forn2) {
                                        if (array_key_exists($_cod_forn2,$_allAttribute)){
                                            $_return['data']['data'][$child['id']]['cod_forn2'] = $_allAttribute[$_cod_forn2];
                                        } else {
                                            $_return['data']['data'][$child['id']]['cod_forn2'] = '';
                                        }
                                    }
                                    if ($_cod_forn3) {
                                        if (array_key_exists($_cod_forn3,$_allAttribute)){
                                            $_return['data']['data'][$child['id']]['cod_forn3'] = $_allAttribute[$_cod_forn3];
                                        } else {
                                            $_return['data']['data'][$child['id']]['cod_forn3'] = '';
                                        }
                                    }
                                    if ($_cod_forn4) {
                                        if (array_key_exists($_cod_forn4,$_allAttribute)){
                                            $_return['data']['data'][$child['id']]['cod_forn4'] = $_allAttribute[$_cod_forn4];
                                        } else {
                                            $_return['data']['data'][$child['id']]['cod_forn4'] = '';
                                        }
                                    }

                                    $_return['data']['data'][$child['id']]['weight']	= $childProduct->weight;

                                    $_return['data']['data'][$child['id']]['height'] 	= $childProduct->height;
                                    $_return['data']['data'][$child['id']]['width'] 	= $childProduct->width;
                                    $_return['data']['data'][$child['id']]['length'] 	= $childProduct->depth;

                                    $_moltiplicator	= $childProduct->height*$childProduct->width*$childProduct->depth;
                                    $_return['data']['data'][$child['id']]['volume']	= $_moltiplicator ? $_moltiplicator/1000000 : 0;
                                }
                            }
                        } else {
                            $_return['data']['data'][$_key]['price']	= number_format($_basePrice,2,'.','');
                            $_return['data']['data'][$_key]['ec_row_id']= $item['id_order_detail'];
                            $_return['data']['data'][$_key]['sku'] = $item['product_reference'];
                            $_return['data']['data'][$_key]['qty'] = $_qty;
                            $_return['data']['data'][$_key]['channel_product_id'] = $item['product_id'];
                            $_customized = '';
                            if (isset($item['customizedDatas']) && $item['customizedDatas']){
                                foreach ($item['customizedDatas'] as $customizedInfo){
                                    foreach ($customizedInfo as $customized){
                                        if (isset($customized['datas']) && $customized['datas']){
                                            foreach ($customized['datas'] as $dataCustomized){
                                                foreach ($dataCustomized as $data){
                                                    $_customized = ' - PERSONALIZZAZIONE : '.$data['name'].' : '.$data['value'];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            $_return['data']['data'][$_key]['name'] = $item['product_name'];
                            $_return['data']['data'][$_key]['original_sku'] = $item['product_reference'];
                            $_return['data']['data'][$_key]['original_name'] = $item['product_name'].$_customized;
                            if (($item['customizable']==2) || ($item['customizable']==1)){
                                $_return['data']['data'][$_key]['tags'][] = 'Personalizzabile&&&&#f800ff';
                            }

                            $image = Image::getCover($item['id_product']);
                            $link = new Link;
                            $imagePath = $link->getImageLink($_product->link_rewrite[Context::getContext()->language->id], $image['id_image'], 'home_default');
                            if ($imagePath){
                                if (strpos($imagePath, 'http') === false) {
                                    $imagePath = 'https://'.$imagePath;
                                }
                            }
                            $_return['data']['data'][$_key]['image'] = $imagePath;
                            if (($_eanAttr) && (array_key_exists($_eanAttr, $item))){
                                $_return['data']['data'][$_key]['ean'] = $item['product_'.$_eanAttr];
                            } else {
                                $_return['data']['data'][$_key]['ean'] = $item['product_ean13'] ? $item['product_ean13'] : '';
                            }

                            $_return['data']['data'][$_key]['actualqty'] 	= StockAvailableCore::getQuantityAvailableByProduct($item['product_id']);

                            $_allAttribute = array();
                            $_features = Product::getFrontFeaturesStatic($id_lang, $item['product_id']);
                            if ($_features){
                                foreach ($_features as $_feature){
                                    $_allAttribute['feat_'.$_feature['id_feature']] = $_feature['value'];
                                }
                            }

                            if ($_product->manufacturer_name){
                                $_allAttribute['manufacturer'] = $_product->manufacturer_name;
                            }

                            if ($_modelAttr) {
                                if (array_key_exists($_modelAttr,$_allAttribute)){
                                    $_return['data']['data'][$_key]['model'] = $_allAttribute[$_modelAttr];
                                } else {
                                    $_return['data']['data'][$_key]['model'] = '';
                                }
                            }
                            if ($_cod_forn1) {
                                if (array_key_exists($_cod_forn1,$_allAttribute)){
                                    $_return['data']['data'][$_key]['cod_forn1'] = $_allAttribute[$_cod_forn1];
                                } else {
                                    $_return['data']['data'][$_key]['cod_forn1'] = '';
                                }
                            }
                            if ($_cod_forn2) {
                                if (array_key_exists($_cod_forn2,$_allAttribute)){
                                    $_return['data']['data'][$_key]['cod_forn2'] = $_allAttribute[$_cod_forn2];
                                } else {
                                    $_return['data']['data'][$_key]['cod_forn2'] = '';
                                }
                            }
                            if ($_cod_forn3) {
                                if (array_key_exists($_cod_forn3,$_allAttribute)){
                                    $_return['data']['data'][$_key]['cod_forn3'] = $_allAttribute[$_cod_forn3];
                                } else {
                                    $_return['data']['data'][$_key]['cod_forn3'] = '';
                                }
                            }
                            if ($_cod_forn4) {
                                if (array_key_exists($_cod_forn4,$_allAttribute)){
                                    $_return['data']['data'][$_key]['cod_forn4'] = $_allAttribute[$_cod_forn4];
                                } else {
                                    $_return['data']['data'][$_key]['cod_forn4'] = '';
                                }
                            }

                            $_return['data']['data'][$_key]['weight']	= $item['weight'] ? $item['weight'] : 0;

                            $_return['data']['data'][$_key]['height'] 	= $item['height'] ? $item['height'] : 0;
                            $_return['data']['data'][$_key]['width'] 	= $item['width'] ? $item['width'] : 0;
                            $_return['data']['data'][$_key]['length'] 	= $item['depth'] ? $item['depth'] : 0;

                            $_moltiplicator	= $item['height']*$item['width']*$item['depth'];
                            $_return['data']['data'][$_key]['volume']	= $_moltiplicator ? $_moltiplicator/1000000 : 0;

                            if ($item['product_attribute_id']){

                                $combination 	= new Combination($item['product_attribute_id']);
                                $_return['data']['data'][$_key]['actualqty'] 	= $combination->quantity;

                                if ($_product->reference == $item['product_reference']) {
                                    $image = Image::getImages($id_lang, $item['product_id'], $item['product_attribute_id']);
                                    if ($image) {
                                        $link 		= new Link;
                                        $imagePath 	= $link->getImageLink($_product->link_rewrite[Context::getContext()->language->id], $item['product_id'] . '-' . $image[0]['id_image'], 'home_default');
                                        if ($imagePath){
                                            $imagePath = 'https://'.$imagePath;
                                            if ($this->ImageExist($imagePath)){
                                                $_return['data']['data'][$_key]['image'] = $imagePath;
                                            }
                                        }
                                    }

                                    if (!$combination->reference){
                                        $_newSku = $_product->reference;
                                    } else {
                                        $_newSku = $combination->reference;
                                    }
                                    /*if ($_product->reference == $_skuCom) {
                                        $attributes 	= $combination->getAttributesName($id_lang);
                                        $_newSku 		= $item['product_reference'];
                                        foreach ($attributes as $attribute){
                                            $_newSku .= '_'.$attribute['name'];
                                        }
                                    } else {
                                        $_newSku = $combination->reference;
                                    }*/
                                    $_return['data']['data'][$_key]['sku'] 		= $_newSku;
                                }
                            }
                        }
                    }

                }

                $_return['data']['is_last'] = $_isLast;
                $_return['data']['dataset'] = $_params;
                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;

                break;

            case 'getOrders':

                if (!$dayToSync){
                    $dayToSync = 15;
                }
                $orderId = '';

                $_query['date'] = array(
                    'field' 	=> 'o.date_add',
                    'operator' 	=> '>=',
                    'filter'	=> date('Y-m-d H:i:s', strtotime('-'.(int)$dayToSync.' days')),
                );
                $_query['state'] = array(
                    'field' 	=> 'o.current_state',
                    'operator' 	=> 'IN',
                    'filter'	=> $_status,
                );

                if (isset($_params['order_id']) && ($orderId = $_params['order_id'])) {
                    $_query['order'] = array(
                        'field' 	=> 'o.id_order',
                        'operator' 	=> '=',
                        'filter'	=> $orderId,
                    );
                    unset($_query['date']);
                    unset($_query['state']);
                }
                if ((isset($_params['order_increment']) && ($orderId = $_params['order_increment'])) || (isset($_params['ecommerce_id']) && ($orderId = $_params['ecommerce_id']))) {
                    $_query['order'] = array(
                        'field' 	=> 'o.reference',
                        'operator' 	=> '=',
                        'filter'	=> $orderId,
                    );
                    unset($_query['date']);
                    unset($_query['state']);
                }


                $_collection = $this->getOrdersWithInformations($limit, null, $start, $_query, false);

                if ($orderId){
                    $_isLast	= true;
                } else {
                    $_collectionTotal = $this->getOrdersWithInformations(10000000, null, 0, $_query);
                    $_lastPage 	= ceil(count($_collectionTotal)/self::LIMIT_FOR_SET);
                    $_isLast 	= $_page == $_lastPage ? true : false;
                }

                if (!count($_collection)){
                    $_return['data']['data'] = array();
                    $_isLast 	= true;
                }

                foreach ($_collection as $_idx => $_order){
                    //print_r($_order);exit;

                    $order = new Order($_order['id_order']);

                    $delivery_details = new Address((int)($_order['id_address_delivery']));

                    $_firstname = $delivery_details->firstname;
                    $_lastname 	= $delivery_details->lastname;
                    $_company	= $delivery_details->company;

                    $address_delivery_country = new Country($delivery_details->id_country);
                    $_country	= $address_delivery_country->iso_code;

                    $address_delivery_state = new State($delivery_details->id_state);
                    $_regionCode= $address_delivery_state->iso_code;
                    $_region 	= $address_delivery_state->name;

                    $_city		= $delivery_details->city;
                    $_postcode	= $delivery_details->postcode;
                    $_street_1	= array();
                    $_street_1[]= $delivery_details->address1;
                    $_street_2	= $delivery_details->address2;
                    if ($_street_2){
                        $_street_1[0] = trim($_street_1[0].' '.$_street_2);
                    }
                    $_mobile	= $delivery_details->phone_mobile;
                    $_phone		= $delivery_details->phone;

                    $_shipment = array();

                    $_shipment['firstname'] = $this->cleanAddressString($_firstname);
                    $_shipment['status'] 	= $_order['state_name'];
                    $_shipment['lastname'] 	= $this->cleanAddressString($_lastname);
                    $_shipment['company'] 	= $this->cleanAddressString($_company);
                    $_shipment['country'] 	= $_country;
                    $_shipment['region'] 	= $this->cleanAddressString($_region);
                    $_shipment['region_code']= $this->cleanAddressString($_regionCode);
                    $_shipment['city'] 		= $this->cleanAddressString($_city);
                    $_shipment['postcode'] 	= $_postcode;
                    $_shipment['street_1'] 	= $_street_1;
                    $_shipment['number'] 	= null;
                    $_shipment['mobile'] 	= str_replace(' ', '', $_mobile);
                    $_shipment['telephone'] = str_replace(' ', '', $_phone);
                    //$_shipment['notes'] 	= $this->cleanAddressString($_order['note']);

                    $_decodedStreet 		= $this->decodeStreet($_shipment);
                    $_shipment['street_1']	= $this->cleanAddressString($_decodedStreet['street_1']);
                    $_shipment['number']	= $this->cleanAddressString($_decodedStreet['number']);
                    $_shipment['notes']		= $this->cleanAddressString($_decodedStreet['notes']);
                    $_shipment['street_1']  = str_replace('U0027 ',"'",$_shipment['street_1']);


                    /*if (strpos($delivery_details->alias, 'POINT_') !== false) {
                        $point = explode('_', $delivery_details->alias);
                        if (isset($point[1]) && $point[1]){
                            $realpoint = $point[1];
                        }
                        if ($realpoint){
                            $_shipment['pudo_data']['pudo_id'] = $realpoint;
                            $_shipment['tags'][] = 'PUDO';
                        }
                    }*/

                    if (!isset($_shipment['tags'])) {
                        $_shipment['tags'] = [];
                    }

                    $products = $order->getProducts();
                    $_allPDF = 0;
                    $_countProd = 0;
                    foreach ($products as $product) {
                        $_product = new Product($product['product_id']);
                        if ($product['product_reference']) {
                            if (($product['customizable']==2) || ($product['customizable']==1)){
                                $_shipment['tags'][] = 'Personalizzabile&&&&#f800ff';
                            }
                        }
                    }

                    $_grandTotal = $_order['total_paid'];

                    $_return['data']['data'][$_idx]						= $_shipment;
                    $_return['data']['data'][$_idx]['ec_customer_id'] 	= $_order['id_customer'];
                    $_return['data']['data'][$_idx]['order_created_at']	= $_order['date_add'];
                    $_return['data']['data'][$_idx]['ecommerce_id'] 	= $_order['reference'];
                    $_return['data']['data'][$_idx]['grand_total'] 		= $_grandTotal;
                    $_return['data']['data'][$_idx]['email'] 			= strtolower($this->cleanAddressString($_order['email']));
                    $_return['data']['data'][$_idx]['erp_id']			= $_order['id_order'];

                    // PAYMENT
                    $_return['data']['data'][$_idx]['payment_method'] 	= $this->cleanShippingMethod($_order['payment']);
                    $_return['data']['data'][$_idx]['payment_method_title'] = $_order['payment'];

                    // SHIPPING
                    $carrier = new Carrier($_order['id_carrier']);

                    $shipping_method_ec = $carrier->id_reference;
                    $shipping_method 	= $carrier->name;

                    if (!$shipping_method){
                        $shipping_method = 'No Shipping Method';
                        $shipping_method_ec = 'No Shipping Method';
                    }

                    if ($isAllPDF){
                        $shipping_method = 'Consegna Prodotti Virtuali';
                        $shipping_method_ec = 'Consegna Prodotti Virtuali';
                    }

                    $_return['data']['data'][$_idx]['shipping_method'] = $this->cleanShippingMethod($shipping_method);
                    $_return['data']['data'][$_idx]['shipping_method_ec'] = $shipping_method_ec;
                    $_return['data']['data'][$_idx]['shipping_method_title'] = $shipping_method;
                    $_return['data']['data'][$_idx]['shipping_method_title_ec'] = $shipping_method;

                    if ($_order['note']){
                        $_return['data']['data'][$_idx]['tags'][] = 'Note&&&&#FFC107';
                        $_return['data']['data'][$_idx]['comment'] = $_order['note'];
                    }
                }

                $_return['data']['is_last'] = $_isLast;
                $_return['data']['dataset'] = $_params;

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;


                break;

            case 'getProducts':

                //mail('info@dfsolution.it','prodotto',Tools::getValue('params'));
                $_query = array();
                if ($_dayToUpdated = $_params['lastdays']) {
                    $_query['date'] = array(
                        'field' 	=> 'p.date_upd',
                        'operator' 	=> '>=',
                        'filter'	=> date('Y-m-d H:i:s', strtotime('-'.(int)$_dayToUpdated.' days')),
                    );
                }
                if ($specific_sku = $_params['products']){
                    $_query['product'] = array(
                        'field' 	=> 'p.reference',
                        'operator' 	=> '=',
                        'filter'	=> $specific_sku,
                    );
                    unset($_query['date']);
                    $_collectionTotal	= 1;
                }

                $order_by	= 'id_product';
                $order_way	= 'ASC';
                $id_category= false;
                $only_active= true;
                $context 	= null;

                if (!$specific_sku){
                    $_collectionTotal	= $this->getProducts($id_lang, 0, 10000000, $order_by, $order_way, $id_category, $only_active , $context, $_query);
                }

                $_collection 	= $this->getProducts($id_lang, $start, $limit, $order_by, $order_way, $id_category, $only_active , $context, $_query);

                if ($specific_sku){
                    $_isLast	= true;
                } else {
                    $_lastPage 	= ceil(count($_collectionTotal)/self::LIMIT_FOR_SET);
                    $_isLast 	= $_page == $_lastPage ? true : false;
                }

                if (!count($_collection)){
                    $_return['data']['data'] = array();
                    $_isLast 	= true;
                }

                foreach($_collection as $product){

                    $_sku = trim($product['reference']);
                    if (!$_sku){
                        continue;
                    }
                    $key = trim($product['reference']);
                    $_product = new Product($product['id_product']);

                    /*if (in_array($_product->product_type, [ProductType::TYPE_PACK])) {
                        continue;
                    }*/

                    $_allAttribute = array();
                    $_features = Product::getFrontFeaturesStatic($id_lang, $product['id_product']);
                    if ($_features){
                        foreach ($_features as $_feature){
                            $_allAttribute['feat_'.$_feature['id_feature']] = $_feature['value'];
                        }
                    }
                    if ($product['manufacturer_name']){
                        $_allAttribute['manufacturer'] = $product['manufacturer_name'];
                    }

                    $_return['data']['data'][$key]['sku'] 	= $product['reference'];

                    if (($product['customizable']==2) || ($product['customizable']==1)){
                        $_return['data']['data'][$key]['tags'][] = 'Personalizzabile&&&&#f800ff';
                    }
                    if ($product['rate']>0){
                        $newprice = $product['price']+(($product['price']/100)*$product['rate']);
                        $product['price'] = number_format($newprice,2,'.','');
                    }

                    if (($_eanAttr) && (array_key_exists($_eanAttr, $product))){
                        $_return['data']['data'][$key]['ean'] = $product[$_eanAttr];
                    } else {
                        $_return['data']['data'][$key]['ean'] = $product['ean13'] ? $product['ean13'] : '';
                    }

                    $_return['data']['data'][$key]['name'] 	= $product['name'];
                    $_return['data']['data'][$key]['channel_product_id']= $product['id_product'];

                    $_return['data']['data'][$key]['qty'] 	= StockAvailableCore::getQuantityAvailableByProduct($product['id_product']);

                    if ($_modelAttr) {
                        if (array_key_exists($_modelAttr,$_allAttribute)){
                            $_return['data']['data'][$key]['model'] = $_allAttribute[$_modelAttr];
                        } else {
                            $_return['data']['data'][$key]['model'] = '';
                        }
                    }
                    if ($_cod_forn1) {
                        if (array_key_exists($_cod_forn1,$_allAttribute)){
                            $_return['data']['data'][$key]['cod_forn1'] = $_allAttribute[$_cod_forn1];
                        } else {
                            $_return['data']['data'][$key]['cod_forn1'] = '';
                        }
                    }
                    if ($_cod_forn2) {
                        if (array_key_exists($_cod_forn2,$_allAttribute)){
                            $_return['data']['data'][$key]['cod_forn2'] = $_allAttribute[$_cod_forn2];
                        } else {
                            $_return['data']['data'][$key]['cod_forn2'] = '';
                        }
                    }
                    if ($_cod_forn3) {
                        if (array_key_exists($_cod_forn3,$_allAttribute)){
                            $_return['data']['data'][$key]['cod_forn3'] = $_allAttribute[$_cod_forn3];
                        } else {
                            $_return['data']['data'][$key]['cod_forn3'] = '';
                        }
                    }
                    if ($_cod_forn4) {
                        if (array_key_exists($_cod_forn4,$_allAttribute)){
                            $_return['data']['data'][$key]['cod_forn4'] = $_allAttribute[$_cod_forn4];
                        } else {
                            $_return['data']['data'][$key]['cod_forn4'] = '';
                        }
                    }

                    $_return['data']['data'][$key]['weight']	= $product['weight'] ? $product['weight'] : 0;

                    $_return['data']['data'][$key]['height'] 	= $product['height'] ? $product['height'] : 0;
                    $_return['data']['data'][$key]['width'] 	= $product['width'] ? $product['width'] : 0;
                    $_return['data']['data'][$key]['length'] 	= $product['depth'] ? $product['depth'] : 0;

                    $_moltiplicator	= $product['height']*$product['width']*$product['depth'];
                    $_return['data']['data'][$key]['volume']	= $_moltiplicator ? $_moltiplicator/1000000 : 0;

                    $_return['data']['data'][$key]['cost'] 		= $product['wholesale_price'];

                    $_return['data']['data'][$key]['price'] 	= $product['price'];
                    $_return['data']['data'][$key]['special_price'] = 0;

                    $_return['data']['data'][$key]['status'] 	= 1;
                    $_return['data']['data'][$key]['tax'] 		= $product['rate'];

                    $_return['data']['data'][$key]['categories'] = [];
                    $categories = $_product->getCategories();
                    $isFilato = false;

                    $image 		= Image::getCover($product['id_product']);
                    $link 		= new Link;
                    $imagePath 	= $link->getImageLink($_product->link_rewrite[Context::getContext()->language->id], $image['id_image'], 'home_default');
                    if ($imagePath){
                        if (strpos($imagePath, 'http') === false) {
                            $imagePath = 'https://'.$imagePath;
                        }
                    }
                    $_return['data']['data'][$key]['image'] 	= $imagePath;

                    if ($_product->hasAttributes()){
                        $_combinations = array();
                        foreach ($_product->getAttributeCombinations() as $combination){
                            if (array_key_exists($combination['id_product_attribute'], $_combinations)){
                                $_combinations[$combination['id_product_attribute']]['additional_attr'][] = $combination['attribute_name'];
                            } else {
                                $_combinations[$combination['id_product_attribute']] = $combination;
                            }
                        }				

                        foreach ($_combinations as $_combination){
                            $_sku = $_combination['reference'];

                            if (!$_sku || ($_sku == $_return['data']['data'][$key]['sku'])){
                                $_sku = $_return['data']['data'][$key]['sku'] . $_combination['id_product'];
                            }

                            $_newkey = $_sku.$_combination['id_product'].$_combination['id_product_attribute'];
                            $_return['data']['data'][$_newkey]	= $_return['data']['data'][$key];
							$_return['data']['data'][$_newkey]['sku'] = $_sku;

							
                            $_return['data']['data'][$_newkey]['qty'] 	= $_combination['quantity'];

                            if ($_combination['price']>0){
                                $_return['data']['data'][$_newkey]['price'] = $_return['data']['data'][$key]['price']+$_combination['price'];
                            }

                            if ($_combination['wholesale_price']>0){
                                $_return['data']['data'][$_newkey]['cost'] = $_combination['wholesale_price'];
                            }

                            if ($_combination['weight']>0){
                                $_return['data']['data'][$_newkey]['weight'] = $_return['data']['data'][$key]['weight']+$_combination['weight'];
                            }

                            if (strpos($_return['data']['data'][$_newkey]['sku'], 'FTC') === false) {
                                if (($_eanAttr) && (array_key_exists($_eanAttr, $_combination))){
                                    $_return['data']['data'][$_newkey]['ean'] = $_combination[$_eanAttr];
                                } else {
                                    if ($_combination['ean13']){
                                        $_return['data']['data'][$_newkey]['ean'] = $_combination['ean13'];
                                    }
                                }
                            }

                            $_return['data']['data'][$_newkey]['categories'] = $_return['data']['data'][$key]['categories'];
                            $image = Image::getImages($id_lang, $product['id_product'], $_combination['id_product_attribute']);
                            $link 		= new Link;
                            if ($image) {
                                $imagePath 	= $link->getImageLink($_product->link_rewrite[Context::getContext()->language->id], $product['id_product'] . '-' . $image[0]['id_image'], 'home_default');
                                if ($imagePath){
                                    $imagePath = 'https://'.$imagePath;
                                    if ($this->ImageExist($imagePath)){
                                        $_return['data']['data'][$_newkey]['image'] = $imagePath;
                                    }
                                }
                            }
                        }
                        unset($_return['data']['data'][$key]);
                    }

                }
                $_return['data']['is_last'] = $_isLast;
                $_return['data']['dataset'] = $_params;

                $_data = json_encode($_return['data']);
                $_return['data'] = array();
                $_return['data'] = $_data;


                break;
            case 'setStock':
                $attributes = Product::getAttributesInformationsByProduct($_params['channel_product_id']);
                if (!$attributes) {
                    $currentStock = StockAvailable::getQuantityAvailableByProduct($_params['channel_product_id'], 0);
                    $newStock = $currentStock + intval($_params['add_new_stock']);
                    StockAvailable::setQuantity($_params['channel_product_id'], 0, $newStock);
                } else {
                    $attributeId = null;
                    foreach ($attributes as $attribute) {
                        $reference = trim(str_replace($attribute['reference'], '', $_params['sku']), '_');
                        if ($reference == $attribute['attribute']) {
                            $attributeId = Product::getIdProductAttributeByIdAttributes($_params['channel_product_id'], $attribute['id_attribute']);
                            break;
                        }
                    }
                    if ($attributeId) {
                        $currentStock = StockAvailable::getQuantityAvailableByProduct($_params['channel_product_id'], $attributeId);
                        $newStock = $currentStock + intval($_params['add_new_stock']);
                        StockAvailable::setQuantity($_params['channel_product_id'], $attributeId, $newStock);
                    }
                }
                $_return['data'] = json_encode([
                    'oldstock' => $currentStock,
                    'newstock' => $newStock
                ]);
                break;
            case 'getStock':
                $attributes = Product::getAttributesInformationsByProduct($_params['channel_product_id']);
                if (!$attributes) {
                    $currentStock = StockAvailable::getQuantityAvailableByProduct($_params['channel_product_id'], 0);
                } else {
                    $attributeId = null;
                    foreach ($attributes as $attribute) {
                        $reference = trim(str_replace($attribute['reference'], '', $_params['sku']), '_');
                        if ($reference == $attribute['attribute']) {
                            $attributeId = Product::getIdProductAttributeByIdAttributes($_params['channel_product_id'], $attribute['id_attribute']);
                            break;
                        }
                    }
                    if ($attributeId) {
                        $currentStock = StockAvailable::getQuantityAvailableByProduct($_params['channel_product_id'], $attributeId);
                    }
                }
                $_return['data'] = json_encode([
                    'quantity' => $currentStock,
                ]);
                break;
            default:
                break;

        }



        $json = Tools::jsonEncode($_return);
        $this->ajaxDie($json);

    }


    public static function getOrdersWithInformations($limit = null, Context $context = null, $start, $_query = '', $_printQuery = false)
    {
        if (!$context) {
            $context = Context::getContext();
        }

        $_additional = '';
        if ($_query){
            foreach ($_query as $key => $_where){
                if (@$_where['field'] && @$_where['operator'] && @$_where['filter']){
                    if ($_where['operator'] == 'IN'){
                        $_additional .= " AND ".$_where['field']." ".$_where['operator']." (".$_where['filter'].")";
                    } else {
                        $_additional .= " AND ".$_where['field']." ".$_where['operator']." '".$_where['filter']."'";
                    }
                }
            }
        }

        $sql = 'SELECT *, (
                    SELECT osl.`name`
                    FROM `' . _DB_PREFIX_ . 'order_state_lang` osl
                    WHERE osl.`id_order_state` = o.`current_state`
                    AND osl.`id_lang` = ' . (int) $context->language->id . '
                    LIMIT 1
                ) AS `state_name`, o.`date_add` AS `date_add`, o.`date_upd` AS `date_upd`
                FROM `' . _DB_PREFIX_ . 'orders` o
                LEFT JOIN `' . _DB_PREFIX_ . 'customer` c ON (c.`id_customer` = o.`id_customer`)
                WHERE 1
                    ' . Shop::addSqlRestriction(false, 'o') . '
					'.$_additional.'
                ORDER BY o.`date_add` DESC
                ' .
            ($limit > 0 ? ' LIMIT ' . (int) $start . ',' . (int) $limit : '');
        echo $_printQuery ? $sql : '';
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    }



    public static function getProducts(
        $id_lang,
        $start,
        $limit,
        $order_by,
        $order_way,
        $id_category = false,
        $only_active = false,
        Context $context = null,
        $_query = ''
    ) {

        if (!$context) {
            $context = Context::getContext();
        }

        $front = true;
        if (!in_array($context->controller->controller_type, array('front', 'modulefront'))) {
            $front = false;
        }

        if (!Validate::isOrderBy($order_by) || !Validate::isOrderWay($order_way)) {
            die(Tools::displayError());
        }

        if ($order_by == 'id_product' || $order_by == 'price' || $order_by == 'date_add' || $order_by == 'date_upd') {
            $order_by_prefix = 'p';
        } elseif ($order_by == 'name') {
            $order_by_prefix = 'pl';
        } elseif ($order_by == 'position') {
            $order_by_prefix = 'c';
        }

        if (strpos($order_by, '.') > 0) {
            $order_by = explode('.', $order_by);
            $order_by_prefix = $order_by[0];
            $order_by = $order_by[1];
        }
        $_additional = '';

        if ($_query){
            foreach ($_query as $key => $_where){
                if (@$_where['field'] && @$_where['operator'] && @$_where['filter']){
                    $_additional .= " AND ".$_where['field']." ".$_where['operator']." '".$_where['filter']."'";
                }
            }
        }

        $sql = 'SELECT p.*, product_shop.*, pl.* , m.`name` AS manufacturer_name, s.`name` AS supplier_name
                FROM `' . _DB_PREFIX_ . 'product` p
                ' . Shop::addSqlAssociation('product', 'p') . '
                LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (p.`id_product` = pl.`id_product` ' . Shop::addSqlRestrictionOnLang('pl') . ')
                LEFT JOIN `' . _DB_PREFIX_ . 'manufacturer` m ON (m.`id_manufacturer` = p.`id_manufacturer`)
                LEFT JOIN `' . _DB_PREFIX_ . 'supplier` s ON (s.`id_supplier` = p.`id_supplier`)' .
            ($id_category ? 'LEFT JOIN `' . _DB_PREFIX_ . 'category_product` c ON (c.`id_product` = p.`id_product`)' : '') . '
                WHERE pl.`id_lang` = ' . (int) $id_lang .
            ($id_category ? ' AND c.`id_category` = ' . (int) $id_category : '') .
            ($front ? ' AND product_shop.`visibility` IN ("both", "catalog")' : '') .
            ($only_active ? ' AND product_shop.`active` = 1' : '') . $_additional . '
                ORDER BY ' . (isset($order_by_prefix) ? pSQL($order_by_prefix) . '.' : '') . '`' . pSQL($order_by) . '` ' . pSQL($order_way) .
            ($limit > 0 ? ' LIMIT ' . (int) $start . ',' . (int) $limit : '');

        $rq = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        if ($order_by == 'price') {
            Tools::orderbyPrice($rq, $order_way);
        }

        foreach ($rq as &$row) {
            $row = Product::getTaxesInformations($row);
        }

        return $rq;
    }

    public function cleanAddressString($_string){
        $_string = trim(strtoupper($_string));
        return $_string;
    }

    public function decodeStreetHelp($_street){
        $_numberFound 	= false;
        $_number		= null;

        for($i = strlen($_street); $i >= 0; $i--){
            $_char = substr($_street, $i, 1);
            if(is_numeric($_char)){
                $_numberFound 	= true;
                $_number 		= $_char.$_number;
            }elseif(!is_numeric($_char) && !$_numberFound){
                $_number = $_char.$_number;
            }elseif($_char == '/' || $_char == "\\"){
                $_number = $_char.$_number;
            }else{
                break;
            }
        }
        if($_number != $_street){
            $_street = trim(str_replace($_number, '', $_street));

            if(strpos($_street.",", ",,") != false){
                $_street = str_replace(",,", "", $_street.",");
            }

            return array(
                'street' => $_street,
                'number' => $_number
            );
        }
        return false;
    }

    public function decodeStreet($_shipment) {
        $_streets = $_shipment['street_1'];

        if(count($_streets) == 1){
            $_decoded = $this->decodeStreetHelp($_streets[0]);
            if($_decoded){
                $_shipment['street_1'] 	= $_decoded['street'];
                $_shipment['number'] 	= $_decoded['number'];
            } else {
                $_shipment['street_1'] 	= $_shipment['street_1'][0];
            }
        }else{
            $_hasDeoded = false;
            foreach($_streets as $_street){
                if(!$_hasDeoded){
                    if($_decoded = $this->decodeStreetHelp($_street)){
                        $_shipment['street_1'] 	= $_decoded['street'];
                        $_shipment['number'] 	= $_decoded['number'];
                        $_hasDeoded 			= true;
                    }else{
                        $_shipment['notes'] .= $_shipment['notes'] ? ' '.$_street : $_street;
                    }
                }else{
                    $_shipment['notes'] .= $_shipment['notes'] ? ' '.$_street : $_street;
                }
            }
        }
        if (is_array($_shipment['street_1'])) {
            $streets2 = $_shipment['street_1'];
            $_shipment['street_1'] = '';
            foreach ($streets2 as $_ship){
                if (is_numeric($_ship)) {
                    $_shipment['number'] 	= $_ship;
                } else {
                    $_shipment['street_1'] .= $_ship;
                }
            }
        }
        $_array_key_co = array('presso','c/o');
        foreach ($_array_key_co as $co) {
            if (strpos($_shipment['number'], $co) !== false) {
                $_shipment['notes'] .= $co.' '.substr(strstr($_shipment['number'], $co), strlen($co));
                $_shipment['number'] = substr($_shipment['number'], 0, strpos($_shipment['number'], $co));
            }
        }

        return $_shipment;

    }

    public function cleanShippingMethod($_methods){
        $_methods = preg_replace("/[^A-Za-z0-9?! ]/","",$_methods);
        $_methods = str_replace(' ','_', $_methods);
        $_methods = str_replace('__','_', $_methods);
        $_methods = strtolower($_methods);
        $_methods = substr($_methods,0,50);
        return $_methods;
    }


}

?>
