<?php
/**
 * Deagor | WMS for Humans
 *
 *
 *  @author    Deagor SRLS <contact@deagor.io>
 *  @copyright 2020 Deagor SRLS
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  @category  Shipping
 *  @package   Deagor
 *  @link      https://deagor.io
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Deagor extends Module
{
    ///protected $config_form = false;

    public function __construct()
    {

        $this->name = 'deagor';
        $this->tab = 'shipping_logistics';
        $this->version = '1.0.0';
        $this->author = 'Deagor';
        $this->author_uri = 'https://deagor.io';
        $this->need_instance = false;

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Deagor');
        $this->description = $this->l('Spedizioni, Tracking e WMS per il tuo store online.');

        $this->confirmUninstall = $this->l('Sei sicuro di voler disinstallare Deagor?');

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {
        Configuration::updateValue('DEAGOR_ENABLE', false);
        Configuration::updateValue('DEAGOR_DAYTOSYNC', '15');
        Configuration::updateValue('DEAGOR_EAN', 'ean13');

        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader');
    }

    public function uninstall()
    {
        Configuration::deleteByName('DEAGOR_ENABLE');
        Configuration::deleteByName('DEAGOR_DAYTOSYNC');
        Configuration::deleteByName('DEAGOR_STATUSSEND');
            
        return parent::uninstall();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        /**
         * If values have been submitted in the form, process.
         */
        if (((bool)Tools::isSubmit('submitDeagorModule')) == true) {
            $this->postProcess();
        }

        $this->context->smarty->assign('module_dir', $this->_path);
        $this->context->smarty->assign('status', Configuration::get('DEAGOR_STATUSSEND', null));

        $output = $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

        return $output.$this->renderForm();
    }

	
	/**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitDeagorModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {	
		
	    $_allAttribute = $this->getAllAttribute();
	    
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Settings'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' 	=> 'switch',
                        'label' => $this->l('Enable Deagor'),
                        'name' 	=> 'DEAGOR_ENABLE',
                        'is_bool'=> true,
                        'desc' 	=> $this->l('Enable Deagor'),
                        'values'=> array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'text',
                        'desc' 	=> $this->l('Deagor Endpoint'),
                        'name' 	=> 'DEAGOR_ENDPOINT',
                        'label' => $this->l('Deagor Endpoint'),
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'text',
                        'required' => true,
                        'desc' 	=> $this->l('Deagor Token'),
                        'name' 	=> 'DEAGOR_TOKEN',
                        'label' => $this->l('Deagor Token'),
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('Model Attribute'),
                        'name' 	=> 'DEAGOR_MODEL',
                        'label' => $this->l('Model Attribute'),
                        'options' => array(
							'query' => $_allAttribute,
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('EAN Attribute'),
                        'name' 	=> 'DEAGOR_EAN',
                        'label' => $this->l('EAN Attribute'),
                        'options' => array(
							'query' => $this->eanAttribute(),
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('Supplier Code 1 Attribute'),
                        'name' 	=> 'DEAGOR_FORN1',
                        'label' => $this->l('Supplier Code 1 Attribute'),
                        'options' => array(
							'query' => $_allAttribute,
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('Supplier Code 2 Attribute'),
                        'name' 	=> 'DEAGOR_FORN2',
                        'label' => $this->l('Supplier Code 2 Attribute'),
                        'options' => array(
							'query' => $_allAttribute,
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('Supplier Code 3 Attribute'),
                        'name' 	=> 'DEAGOR_FORN3',
                        'label' => $this->l('Supplier Code 3 Attribute'),
                        'options' => array(
							'query' => $_allAttribute,
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => false,
                        'desc' 	=> $this->l('Supplier Code 4 Attribute'),
                        'name' 	=> 'DEAGOR_FORN4',
                        'label' => $this->l('Supplier Code 4 Attribute'),
                        'options' => array(
							'query' => $_allAttribute,
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => true,
                        'desc' 	=> $this->l('Days to Sync orders'),
                        'name' 	=> 'DEAGOR_DAYTOSYNC',
                        'label' => $this->l('Days to Sync orders'),
                        'options' => array(
							'query' => $this->daytosync(),
							'id' 	=> 'id_option', 
							'name' 	=> 'name'
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'checkbox',
                        'required' => true,
                        'desc' 	=> $this->l('Select the state in which you have to find the order to be sent to the Deagor. NOT SELECT SHIPPED STATUS.'),
                        'name' 	=> 'DEAGOR_STATUSSEND[]',
                        'label' => $this->l('Send Status'),
                        'values' => array(
							'query' => $this->getAllStatus(),
							'id' 	=> 'id', 
							'name' 	=> 'name',
                        )
                    ),
                    array(
                        'col' 	=> 3,
                        'type' 	=> 'select',
                        'required' => true,
                        'desc' 	=> $this->l('Status per ordine consegnato'),
                        'name' 	=> 'DEAGOR_STATUSDELIVER',
                        'label' => $this->l('Status per ordine consegnato'),
                        'options' => array(
							'query' => $this->getAllStatus(),
							'id' 	=> 'id', 
							'name' 	=> 'name'
                        )
                    ),
                    /*array(
                        'type' 	=> 'switch',
                        'label' => $this->l('Send Shipping Email'),
                        'name' 	=> 'DEAGOR_SHIPEMAIL',
                        'is_bool'=> true,
                        'desc' 	=> $this->l('Send Shipping Email'),
                        'values'=> array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),*/
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),
        );
    }
	
	public function getAllAttribute(){
		$_return = array();
		$_return[] = array(
	    	"id_option" => 0,
            "name" 		=> ' -- Select Attribute --',
        );
		//$attrlists 	= Attribute::getAttributes(1, $not_null = false);
		$featlists  = Feature::getFeatures(1, $not_null = false);
		/*if ($attrlists){
			foreach ($attrlists as $attr){
				$_return['attr_'.$attr['id_attribute_group']] = array(
			    	"id_option" => 'attr_'.$attr['id_attribute_group'],
		            "name" 		=> 'Attribute : '.$attr['attribute_group'],
		        );
			}	
		}*/
		$_return['manufacturer'] = array(
		    	"id_option" => 'manufacturer',
	            "name" 		=> 'Manufacturer',
	        );

		if ($featlists){
			foreach ($featlists as $attr){
				$_return['feat_'.$attr['id_feature']] = array(
			    	"id_option" => 'feat_'.$attr['id_feature'],
		            "name" 		=> $attr['name'],
		        );
			}	
		}
        return $_return;
	}
	
	public function eanAttribute(){
		$_return = array();
		$_return[] = array(
	    	"id_option" => 0,
            "name" 		=> ' -- Select EAN Attribute --',
        );
        $_return[] = array(
	    	"id_option" => 'isbn',
            "name" 		=> 'ISBN',
        );
        $_return[] = array(
	    	"id_option" => 'ean13',
            "name" 		=> 'EAN 13 or JAN',
        );
        $_return[] = array(
	    	"id_option" => 'upc',
            "name" 		=> 'UPC',
        );
        return $_return;
	}
	
	public function getAllStatus(){
		$_return 	= array();
		$_states 	= new OrderState(1);
		$_status 	= $_states->getOrderStates(1);
		$_shippedStatus 	= Configuration::get('PS_OS_SHIPPING');
		$_cancelledStatus 	= Configuration::get('PS_OS_CANCELED');
		foreach ($_status as $status){
			if (($status['id_order_state'] == $_shippedStatus) || ($status['id_order_state'] == $_cancelledStatus)){
				continue;
			}
			$_return[] = array(
		    	"id" => $status['id_order_state'],
	            "name" 		=> $status['name'],
	            "val"=> $status['id_order_state'],
	        );
		}
		return $_return;
	}
	
	public function daytosync() {
		$_return = array();
		$_return[] = array(
	    	"id_option" => 0,
            "name" 		=> ' -- Select how many Days to Sync --',
        );
		for( $i=1; $i<=90; $i++ ) {
			$_return[] = array(
		    	"id_option" => $i,
	            "name" 		=> $i.' Days',
            );
		}
		return $_return;
	}
	
    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        return array(
            'DEAGOR_ENABLE' 	=> Configuration::get('DEAGOR_ENABLE', true),
            'DEAGOR_ENDPOINT' 	=> Configuration::get('DEAGOR_ENDPOINT', null),
            'DEAGOR_TOKEN' 		=> Configuration::get('DEAGOR_TOKEN', null),
            'DEAGOR_DAYTOSYNC' 	=> Configuration::get('DEAGOR_DAYTOSYNC', 0),
            'DEAGOR_STATUSSEND' => Configuration::get('DEAGOR_STATUSSEND', null),
            'DEAGOR_STATUSDELIVER' => Configuration::get('DEAGOR_STATUSDELIVER', null),
            'DEAGOR_EAN' 		=> Configuration::get('DEAGOR_EAN', null),
            'DEAGOR_MODEL' 		=> Configuration::get('DEAGOR_MODEL', null),
            'DEAGOR_FORN1' 		=> Configuration::get('DEAGOR_FORN1', null),
            'DEAGOR_FORN2' 		=> Configuration::get('DEAGOR_FORN2', null),
            'DEAGOR_FORN3' 		=> Configuration::get('DEAGOR_FORN3', null),
            'DEAGOR_FORN4' 		=> Configuration::get('DEAGOR_FORN4', null),
        );
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {

	        if ($key == 'DEAGOR_STATUSSEND'){
		        $_value = implode(',',Tools::getValue($key));
		        Configuration::updateValue($key, $_value);
	        } else {
		    	Configuration::updateValue($key, Tools::getValue($key));    
	        }   
        }
    }

    /** 
    * Add the CSS & JavaScript files you want to be loaded in the BO.
    */
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path.'views/js/back.js');
            $this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }
    
}
